/*----------------------------------------------------------------------------
 * Name:    led.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 *----------------------------------------------------------------------------*/
#include	"led.h"

u8		LEDFlashStatus;
u16	LEDFlashTimer[5];
u16	LEDFlashTmCnt[5];

/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_InterfaceConfigure(void)
{	
   /* configure LED as GPIO  */
   _pgs0 &= 0x3F;
   _pgs1 = 0;
   /* configure LED as output mode  */
   _pgc &= ~(LED1OM | LED2OM | LED3OM | LED4OM | LEDPOM);
   /* configure LED as OFF  */
   _pg |= (LED1OM | LED2OM | LED3OM | LED4OM | LEDPOM);
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_AlwaysOn(u8 led)
{
	u8 x,m,m1;
	
	m = LED1;
	m1 = LED1OM;
	
	for(x=0; x<5 ; x++)
	{
		if(led & m)
		{
			LEDFlashStatus &= ~m;
			_pg &= ~m1;
		}
		GCC_RL(m);
		GCC_RR(m1);
	}	
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_AlwaysOff(u8 led)
{
	u8 x,m,m1;
	
	m = LED1;
	m1 = LED1OM;
	
	for(x=0; x<5 ; x++)
	{
		if(led & m)
		{
			LEDFlashStatus &= ~m;
			_pg |= m1;
		}
		GCC_RL(m);
		GCC_RR(m1);
	}	
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_FlashEnable(u8 led,u16 timer)
{
	u8 x,m,m1;
	
	m = LED1;
	m1 = LED1OM;
	
	for(x=0; x<5 ; x++)
	{
		if(led & m)
		{
			LEDFlashStatus |= m;
			LEDFlashTimer[x] = timer;
			LEDFlashTmCnt[x] = timer;
			_pg &= ~m1;
		}
		GCC_RL(m);
		GCC_RR(m1);
	}	
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_FlashProcess(void)
{
	u8 x,m,m1;
	
	m = LED1;
	m1 = LED1OM;

	for(x=0; x<5 ; x++)
	{	
		if(LEDFlashStatus & m)
		{
			if(--LEDFlashTmCnt[x] == 0)
			{
				LEDFlashTmCnt[x] = LEDFlashTimer[x];
				_pg ^= m1;
			}
		}
		GCC_RL(m);
		GCC_RR(m1);
	}
}
